#include <Arduino.h>
#include <BLEMidi.h> // https://github.com/lathoub/Arduino-BLE-MIDI
#include <analogWrite.h>

#define PULSE_PIN 35 // analog in for Pulse Sensor

int ledPin = 22; 
void connected();
void disconnected();

int Signal = 0;  
int Threshold = 2700; 
bool beatDispatched = false;

//////////////////////////////////
void onNoteOn(uint8_t channel, uint8_t note, uint8_t velocity, uint16_t timestamp)
{

  digitalWrite(ledPin, LOW);
  
//  Serial.printf("Received note on : channel %d, note %d, velocity %d (timestamp %dms)\n", channel, note, velocity, timestamp);

  if(note == 60){
//    Serial.printf("- C - ON  :  vel %d \n", velocity);
  }   

}

//////////////////////////////////
void onNoteOff(uint8_t channel, uint8_t note, uint8_t velocity, uint16_t timestamp)
{

   digitalWrite(ledPin, HIGH);

//  Serial.printf("Received note off : channel %d, note %d, velocity %d (timestamp %dms)\n", channel, note, velocity, timestamp);
  if(note == 60){
//    Serial.printf("- C - OFF \n");
//    analogWrite(motorPin1, 0);

  }
}

//////////////////////////////////
void onControlChange(uint8_t channel, uint8_t controller, uint8_t value, uint16_t timestamp)
{
    Serial.printf("Received control change : channel %d, controller %d, value %d (timestamp %dms)\n", channel, controller, value, timestamp);
}

//////////////////////////////////
void connected()
{
  Serial.println("Connected");
}

//////////////////////////////////
void disconnected()
{
  Serial.println("Disconnected");
}


//////////////////////////////////
void setup() {

  pinMode(PULSE_PIN, INPUT); 

  Serial.begin(115200);
  BLEMidiServer.begin("SoS-Pulser");
  BLEMidiServer.setOnConnectCallback(connected);
  BLEMidiServer.setOnDisconnectCallback(disconnected);


  Serial.println(" INIT ");

           
//  BLEMidiServer.setOnDisconnectCallback([](){     // To show how to make a callback with a lambda function
//    Serial.println("Disconnected");
//  });

//  BLEMidiServer.setNoteOnCallback(onNoteOn);
//  BLEMidiServer.setNoteOffCallback(onNoteOff);
  
//  BLEMidiServer.setControlChangeCallback(onControlChange);
  //BLEMidiServer.enableDebugging();
}


////////////////////////////////////
void loop() {

  // Pulse Sensor
  Signal = analogRead(PULSE_PIN);  // Read the PulseSensor’s value.
  int pulseReading = map(Signal,1000,2500,0,127);
  pulseReading = constrain(pulseReading, 0, 127); 

  Serial.print(64); 
  Serial.print(" "); 
  Serial.println(pulseReading);  
             
  //  BLEMidiServer.controlChange(uint8_t channel, uint8_t controller, uint8_t value);
  if (BLEMidiServer.isConnected()) {
  
    
      if(Signal > Threshold && beatDispatched == false){ 
           BLEMidiServer.controlChange(0, 125, 127);
           beatDispatched = true; 
           Serial.print(" >>> ");
           Serial.println(Signal);  
    
      } else  {
        if(Signal < (Threshold / 1.5)){    
            BLEMidiServer.controlChange(0, 125, 0); 
            beatDispatched = false ; 
            delay(10);
         }
    
           Serial.print(" <<< ");
           Serial.println(Signal);  
      }
    
  }    

  delay(20);

}
