// Pulse sensor reading and OSC transmission
// S.o.S. Sense Of Self - v 2.0
// TeZ, Sept 2022

#include <WiFi.h>
#include <WiFiUdp.h>
#include <OSCMessage.h>
#include <analogWrite.h>
#include <Adafruit_NeoPixel.h>

#define USESERIAL false
#define LED_PIN    14
#define LED_COUNT 1

Adafruit_NeoPixel strip(LED_COUNT, LED_PIN, NEO_GRB + NEO_KHZ800);

////////////////////////////////////////////////  
int WID = 7; // ID# OF THIS ESP32 BOARD 
int SENDER = 3;  // here write the number of the sender you want to respond to
const char* BOARDMODE = "receiver";
// const char* BOARDMODE = "sender";
////////////////////////////////////////////////  
// WiFi CREDENTIALS
const char* ssid = "sos-net";// "Fablab-Guest";
const char* pass = "sos-pass"; // "naomelembro";



WiFiUDP Udp;
const IPAddress dest(192, 168, 4, 255); // BROADCAST
unsigned int rxport = 12345; // local ESP32 port to listen OSC
unsigned int txport = 54321; // remote port to receive OSC
IPAddress thisip;

int PulseSensorPin = 35; // analog in for Pulse Sensor
int LEDPIN = 1;   //  The on-board LED
int Signal;  
int Threshold = 2700; 

int MOTORPIN = 19;

int device_id = -1;
int WIP[]={0,0,0,0};
int hold = 1;
bool firstime = true;

float lastreading, thisreading;
float IBI = 0;
unsigned long lastbeat = 0;
unsigned long now = 0;
int sensor_id = -1;
bool beatDispatched = false;

float vibration = 100;
bool vibrostate = false;

///////////////////////////////////
void colorWipe(uint32_t color, int wait) {
  for(int i=0; i<strip.numPixels(); i++) { // For each pixel in strip...
    strip.setPixelColor(i, color);         //  Set pixel's color (in RAM)
    strip.show();                          //  Update strip to match
    delay(wait);                           //  Pause for a moment
  }
}


////////////////////////////////////
void setup() {

  if(BOARDMODE == "receiver"){
    rxport = 12345; 
    txport = 54321;     
  }else{
    txport = 12345; 
    rxport = 54321;     
  }

  pinMode(PulseSensorPin,INPUT); // analog input     
  pinMode(LEDPIN,OUTPUT); // internal ESP32 led       
  pinMode(MOTORPIN,OUTPUT); // motor pin      
 

  if(USESERIAL){
    Serial.begin(115200); 
  }

     // connect to WiFi
      if(USESERIAL){
      Serial.println();
      Serial.println();
      Serial.print("Connecting to ");
      Serial.println(ssid);    
      } 
      WiFi.begin(ssid, pass);    
      while (WiFi.status() != WL_CONNECTED) {
        delay(500);
         if(USESERIAL){Serial.print(".");}
      }   

  colorWipe(strip.Color(255,   0,   0), 90); 
  delay(1000);
  colorWipe(strip.Color(0,   255,   0), 90); 
  delay(1000);
  colorWipe(strip.Color(0,   0,   255), 90); 
  delay(1000);
  
      if(USESERIAL){ 
        Serial.println("");
        Serial.println("WiFi connected");  
        Serial.println("IP address: ");
        thisip = WiFi.localIP();
        Serial.println( thisip );
      }

      Udp.begin(rxport);
       if(USESERIAL){Serial.println("Starting UDP");}

      for(int n=1; n<=3;n++){
          digitalWrite(LEDPIN,LOW);  
          delay(200);
          digitalWrite(LEDPIN,HIGH);  
          delay(200);    
 
      }


    analogWrite(MOTORPIN, 0);


  
}

////////////////////////////////////
void loop() {

  if (BOARDMODE == "sender"){
        senderLoop();
        delay(20);
  }else{
        osc_message_pump();
        delay(20);
  }

}
///////////////////////////////////
void senderLoop(){

  Signal = analogRead(PulseSensorPin);  // Read the PulseSensor’s value.
  // SendSignal(Signal);

   if(USESERIAL){Serial.println(Signal);}  

  if(Signal > Threshold && beatDispatched == false){ 
      digitalWrite(LEDPIN,LOW);
       SendBeat(HIGH);
       beatDispatched = true; 
       

  } else  {
     digitalWrite(LEDPIN,HIGH); 
    if(Signal < (Threshold / 1.5)){     
      beatDispatched = false ; 

      delay(10);
      SendBeat(LOW);
     }
  }

}


///////////////////////////////////
void SendBeat(bool beatstate) {

     OSCMessage out("/sos/beat");
    out.add(WID);
     if(beatstate == HIGH){
        out.add(1);
     }else{
      out.add(0);
     }
     Udp.beginPacket(dest, txport);
     out.send(Udp);
     Udp.endPacket();
}
///////////////////////////////////
void SendSignal(int mySignal) {

     OSCMessage out("/sos/signal");
     out.add(WID);
     out.add(mySignal);
     Udp.beginPacket(dest, txport);
     out.send(Udp);
     Udp.endPacket();
}
//////////////////////////////////
/////////////////////////////////////
/// READ OSC MESSAGES ///
void osc_message_pump() {  
  OSCMessage in;
  int size;

  if( (size = Udp.parsePacket()) > 0)
  {
    if(USESERIAL){ Serial.println("processing OSC package");}
    // parse incoming OSC message
    while(size--) {
      in.fill( Udp.read() );
    }

    if(!in.hasError()) {
      in.route("/wemos/ack", on_ack);
      in.route("/sos/beat", on_beat);
    }
  } 
}



/////////////////////////////////////
void on_beat(OSCMessage &msg, int addrOffset) {
  
   int sender_id;
   float value; 
  if(msg.isInt(0)) {
      sender_id = msg.getInt(0);
      value = msg.getInt(1);
    }

//  if(sender_id == SENDER){  // discriminate the source, only receive from selected sender
  if(true){  // discriminate the source, only receive from selected sender

      if(value){
          digitalWrite(LEDPIN,HIGH); 
          colorWipe(strip.Color(0,   255,   0), 90); 
          analogWrite(MOTORPIN, 0);
      }else{
          digitalWrite(LEDPIN,LOW);  
          colorWipe(strip.Color(0,   0,   255), 90); 
          analogWrite(MOTORPIN, 150);
      }

   if(USESERIAL){
        Serial.print("OSC beat message value: ");
        Serial.println(value);
      }
      
//        vibrostate = !(vibrostate);  
//         if (vibrostate){
//           analogWrite(vibropin, 100);
//           ledcWrite(0, 100);
//         }else{
//          analogWrite(vibropin, 0);        
//         }

  }
  

}

/////////////////////////////////////
void on_ack(OSCMessage &msg, int addrOffset) {
 
   int sender_id;
   float value; 
  if(msg.isInt(0)) {
    sender_id = msg.getInt(0);
    value = msg.getInt(1);
  }

 if(USESERIAL){
    Serial.print("OSC ACK message value: ");
    Serial.println(value);
 }
    

}
